#property link          "https://www.earnforex.com/metatrader-indicators/ma-ribbon-alert/"
#property version       "1.00"
#property strict
#property copyright     "EarnForex.com - 2019-2021"
#property description   "The Moving Average Ribbon With Alert"
#property description   " "
#property description   "WARNING : You use this software at your own risk."
#property description   "The creator of these plugins cannot be held responsible for damage or loss."
#property description   " "
#property description   "Find More on EarnForex.com"
#property icon          "\\Files\\EF-Icon-64x64px.ico"

#property indicator_chart_window
#property indicator_buffers 8

//#include <MQLTA ErrorHandling.mqh>
//#include <MQLTA Utils.mqh>

enum ENUM_TRADE_SIGNAL{
   SIGNAL_BUY=1,     //BUY
   SIGNAL_SELL=-1,   //SELL
   SIGNAL_NEUTRAL=0  //NEUTRAL
};

enum ENUM_SIGNAL_TYPE{
   SIGNAL_RIBBON_ALIGN=0,     //RIBBON ALIGNED
   SIGNAL_CANDLE_CLOSE=1      //CANDLE CLOSE OUTSIDE RIBBON
};

enum ENUM_CANDLE_TO_CHECK{
   CURRENT_CANDLE=0,    //CURRENT CANDLE
   CLOSED_CANDLE=1      //PREVIOUS CANDLE
};

enum ENUM_ALERT_SIGNAL{

};

input string Comment1="========================";     //MQLTA Trend Ribbon With Alert
input string IndicatorName="MQLTA-MARWA";              //Indicator Short Name

input string Comment2="========================";     //Indicator Parameters
input int MAPeriod=10;                                //Starting Moving Average Period
input ENUM_APPLIED_PRICE MAPrice=PRICE_CLOSE;         //Moving Average Applied Price
input ENUM_MA_METHOD MAMode=MODE_EMA;                 //Moving Average Type
int MAShift=0;
input int MAPeriodIncrement=5;                        //Moving Average Period Increment   
input ENUM_CANDLE_TO_CHECK CandleToCheck=CURRENT_CANDLE;    //Candle To Use For Analysis
input ENUM_SIGNAL_TYPE SignalMode=SIGNAL_CANDLE_CLOSE;   //When To Notify
input int BarsToScan=1000;                                   //Number Of Candles To Analyse

input string Comment_3="====================";     //Notification Options
extern bool EnableNotify=false;                    //Enable Notifications Feature
extern bool SendAlert=true;                        //Send Alert Notification
extern bool SendApp=true;                          //Send Notification to Mobile
extern bool SendEmail=true;                        //Send Notification via Email
input int WaitTimeNotify=5;                        //Wait time between notifications (Minutes)

input string Comment_4="====================";     //Drawing Options
input int LineThickness=2;                         //Ribbon Thickness
input color LineColor=clrGold;               //Ribbon Color
input bool EnableDrawArrows=true;                  //Draw Signal Arrows
input int ArrowBuy=241;                            //Buy Arrow Code
input int ArrowSell=242;                           //Sell Arrow Code
input int ArrowSize=3;                             //Arrow Size (1-5)

double Buffer0[];
double Buffer1[];
double Buffer2[];
double Buffer3[];
double Buffer4[];
double Buffer5[];
double Buffer6[];
double Buffer7[];

datetime LastNotificationTime;
int Shift=0;


int OnInit(void){

   IndicatorSetString(INDICATOR_SHORTNAME,IndicatorName);

   OnInitInitialization();
   if(!OnInitPreChecksPass()){
      return(INIT_FAILED);
   }   

   InitialiseBuffers();

   return(INIT_SUCCEEDED);
}


int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]){

   bool IsNewCandle=CheckIfNewCandle();
   int i,pos,upTo;

   pos=0;
   if(prev_calculated==0 || IsNewCandle)
      upTo=BarsToScan-1;
   else
      upTo=0;

   for(i=pos; i<=upTo && !IsStopped(); i++){
      int j=0;
      Buffer0[i]=iMA(Symbol(),PERIOD_CURRENT,MAPeriod+j*MAPeriodIncrement,MAShift,MAMode,MAPrice,i); j++;
      Buffer1[i]=iMA(Symbol(),PERIOD_CURRENT,MAPeriod+j*MAPeriodIncrement,MAShift,MAMode,MAPrice,i); j++;
      Buffer2[i]=iMA(Symbol(),PERIOD_CURRENT,MAPeriod+j*MAPeriodIncrement,MAShift,MAMode,MAPrice,i); j++;
      Buffer3[i]=iMA(Symbol(),PERIOD_CURRENT,MAPeriod+j*MAPeriodIncrement,MAShift,MAMode,MAPrice,i); j++;
      Buffer4[i]=iMA(Symbol(),PERIOD_CURRENT,MAPeriod+j*MAPeriodIncrement,MAShift,MAMode,MAPrice,i); j++;
      Buffer5[i]=iMA(Symbol(),PERIOD_CURRENT,MAPeriod+j*MAPeriodIncrement,MAShift,MAMode,MAPrice,i); j++;
      Buffer6[i]=iMA(Symbol(),PERIOD_CURRENT,MAPeriod+j*MAPeriodIncrement,MAShift,MAMode,MAPrice,i); j++;
      Buffer7[i]=iMA(Symbol(),PERIOD_CURRENT,MAPeriod+j*MAPeriodIncrement,MAShift,MAMode,MAPrice,i); j++;
   }
     
   if(IsNewCandle || prev_calculated==0){
      if(EnableDrawArrows) DrawArrows();
   }
   
   if(EnableDrawArrows)
      DrawArrow(0);

   if(EnableNotify)
      NotifyHit();
      
   return(rates_total);
}
  
  
void OnDeinit(const int reason){
   CleanChart();
}  


void OnInitInitialization(){
   LastNotificationTime=TimeCurrent();
   Shift=CandleToCheck;
}


bool OnInitPreChecksPass(){
   if(MAPeriod<=0){
      Print("Wrong input parameter");
      return false;
   }   
   if(Bars(Symbol(),PERIOD_CURRENT)<BarsToScan+MAPeriod+MAPeriodIncrement*7){
      Print("Not Enough Historical Candles");
      Alert("Not Enough Historical Candles");
      return false;
   }   
   return true;
}


void CleanChart(){
   int Window=0;
   for(int i=ObjectsTotal(ChartID(),Window,-1)-1;i>=0;i--){
      if(StringFind(ObjectName(i),IndicatorName,0)>=0){
         ObjectDelete(ObjectName(i));
      }
   }
}


void InitialiseBuffers(){
   IndicatorBuffers(3);
   IndicatorDigits(Digits);
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,LineThickness,LineColor);
   SetIndexBuffer(0,Buffer0);
   SetIndexLabel(0,"MA0");
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,LineThickness,LineColor);
   SetIndexBuffer(1,Buffer1);
   SetIndexLabel(1,"MA1");
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,LineThickness,LineColor);
   SetIndexBuffer(2,Buffer2);
   SetIndexLabel(2,"MA2");
   SetIndexStyle(3,DRAW_LINE,STYLE_SOLID,LineThickness,LineColor);
   SetIndexBuffer(3,Buffer3);
   SetIndexLabel(3,"MA3");
   SetIndexStyle(4,DRAW_LINE,STYLE_SOLID,LineThickness,LineColor);
   SetIndexBuffer(4,Buffer4);
   SetIndexLabel(4,"MA4");
   SetIndexStyle(5,DRAW_LINE,STYLE_SOLID,LineThickness,LineColor);
   SetIndexBuffer(5,Buffer5);
   SetIndexLabel(5,"MA5");
   SetIndexStyle(6,DRAW_LINE,STYLE_SOLID,LineThickness,LineColor);
   SetIndexBuffer(6,Buffer6);
   SetIndexLabel(6,"MA6");
   SetIndexStyle(7,DRAW_LINE,STYLE_SOLID,LineThickness,LineColor);
   SetIndexBuffer(7,Buffer7);
   SetIndexLabel(7,"MA7");
}


datetime NewCandleTime=TimeCurrent();
bool CheckIfNewCandle(){
   if(NewCandleTime==iTime(Symbol(),0,0)) return false;
   else{
      NewCandleTime=iTime(Symbol(),0,0);
      return true;
   }
}


//Check if it is a trade Signla 0 - Neutral, 1 - Buy, -1 - Sell
ENUM_TRADE_SIGNAL IsSignal(int i){
   int j=i+Shift;
   if(SignalMode==SIGNAL_RIBBON_ALIGN){
      if((Buffer0[i]>Buffer1[i] && Buffer0[i]>Buffer2[i] && Buffer0[i]>Buffer3[i] && Buffer0[i]>Buffer4[i] && Buffer0[i]>Buffer5[i] && Buffer0[i]>Buffer6[i] && Buffer0[i]>Buffer7[i] && 
         Buffer1[i]>Buffer2[i] && Buffer1[i]>Buffer3[i] && Buffer1[i]>Buffer4[i] && Buffer1[i]>Buffer5[i] && Buffer1[i]>Buffer6[i] && Buffer1[i]>Buffer7[i] && 
         Buffer2[i]>Buffer3[i] && Buffer2[i]>Buffer4[i] && Buffer2[i]>Buffer5[i] && Buffer2[i]>Buffer6[i] && Buffer2[i]>Buffer7[i] && 
         Buffer3[i]>Buffer4[i] && Buffer3[i]>Buffer5[i] && Buffer3[i]>Buffer6[i] && Buffer3[i]>Buffer7[i] && 
         Buffer4[i]>Buffer5[i] && Buffer4[i]>Buffer6[i] && Buffer4[i]>Buffer7[i] && 
         Buffer5[i]>Buffer6[i] && Buffer5[i]>Buffer7[i] && 
         Buffer6[i]>Buffer7[i]) &&
         !(Buffer0[i+1]>Buffer1[i+1] && Buffer0[i+1]>Buffer2[i+1] && Buffer0[i+1]>Buffer3[i+1] && Buffer0[i+1]>Buffer4[i+1] && Buffer0[i+1]>Buffer5[i+1] && Buffer0[i+1]>Buffer6[i+1] && Buffer0[i+1]>Buffer7[i+1] && 
         Buffer1[i+1]>Buffer2[i+1] && Buffer1[i+1]>Buffer3[i+1] && Buffer1[i+1]>Buffer4[i+1] && Buffer1[i+1]>Buffer5[i+1] && Buffer1[i+1]>Buffer6[i+1] && Buffer1[i+1]>Buffer7[i+1] && 
         Buffer2[i+1]>Buffer3[i+1] && Buffer2[i+1]>Buffer4[i+1] && Buffer2[i+1]>Buffer5[i+1] && Buffer2[i+1]>Buffer6[i+1] && Buffer2[i+1]>Buffer7[i+1] && 
         Buffer3[i+1]>Buffer4[i+1] && Buffer3[i+1]>Buffer5[i+1] && Buffer3[i+1]>Buffer6[i+1] && Buffer3[i+1]>Buffer7[i+1] && 
         Buffer4[i+1]>Buffer5[i+1] && Buffer4[i+1]>Buffer6[i+1] && Buffer4[i+1]>Buffer7[i+1] && 
         Buffer5[i+1]>Buffer6[i+1] && Buffer5[i+1]>Buffer7[i+1] && 
         Buffer6[i+1]>Buffer7[i+1]))
            return SIGNAL_BUY;
      if((Buffer0[i]<Buffer1[i] && Buffer0[i]<Buffer2[i] && Buffer0[i]<Buffer3[i] && Buffer0[i]<Buffer4[i] && Buffer0[i]<Buffer5[i] && Buffer0[i]<Buffer6[i] && Buffer0[i]<Buffer7[i] && 
         Buffer1[i]<Buffer2[i] && Buffer1[i]<Buffer3[i] && Buffer1[i]<Buffer4[i] && Buffer1[i]<Buffer5[i] && Buffer1[i]<Buffer6[i] && Buffer1[i]<Buffer7[i] && 
         Buffer2[i]<Buffer3[i] && Buffer2[i]<Buffer4[i] && Buffer2[i]<Buffer5[i] && Buffer2[i]<Buffer6[i] && Buffer2[i]<Buffer7[i] && 
         Buffer3[i]<Buffer4[i] && Buffer3[i]<Buffer5[i] && Buffer3[i]<Buffer6[i] && Buffer3[i]<Buffer7[i] && 
         Buffer4[i]<Buffer5[i] && Buffer4[i]<Buffer6[i] && Buffer4[i]<Buffer7[i] && 
         Buffer5[i]<Buffer6[i] && Buffer5[i]<Buffer7[i] && 
         Buffer6[i]<Buffer7[i]) &&
         !(Buffer0[i+1]<Buffer1[i+1] && Buffer0[i+1]<Buffer2[i+1] && Buffer0[i+1]<Buffer3[i+1] && Buffer0[i+1]<Buffer4[i+1] && Buffer0[i+1]<Buffer5[i+1] && Buffer0[i+1]<Buffer6[i+1] && Buffer0[i+1]<Buffer7[i+1] && 
         Buffer1[i+1]<Buffer2[i+1] && Buffer1[i+1]<Buffer3[i+1] && Buffer1[i+1]<Buffer4[i+1] && Buffer1[i+1]<Buffer5[i+1] && Buffer1[i+1]<Buffer6[i+1] && Buffer1[i+1]<Buffer7[i+1] && 
         Buffer2[i+1]<Buffer3[i+1] && Buffer2[i+1]<Buffer4[i+1] && Buffer2[i+1]<Buffer5[i+1] && Buffer2[i+1]<Buffer6[i+1] && Buffer2[i+1]<Buffer7[i+1] && 
         Buffer3[i+1]<Buffer4[i+1] && Buffer3[i+1]<Buffer5[i+1] && Buffer3[i+1]<Buffer6[i+1] && Buffer3[i+1]<Buffer7[i+1] && 
         Buffer4[i+1]<Buffer5[i+1] && Buffer4[i+1]<Buffer6[i+1] && Buffer4[i+1]<Buffer7[i+1] && 
         Buffer5[i+1]<Buffer6[i+1] && Buffer5[i+1]<Buffer7[i+1] && 
         Buffer6[i+1]<Buffer7[i+1]))
            return SIGNAL_SELL;   
   }
   if(SignalMode==SIGNAL_CANDLE_CLOSE){
      if((Close[i]>Buffer0[i] && Close[i]>Buffer1[i] && Close[i]>Buffer2[i] && Close[i]>Buffer3[i] && Close[i]>Buffer4[i] && Close[i]>Buffer5[i] && Close[i]>Buffer6[i] && Close[i]>Buffer7[i]) &&
         !(Close[i+1]>Buffer0[i+1] && Close[i+1]>Buffer1[i+1] && Close[i+1]>Buffer2[i+1] && Close[i+1]>Buffer3[i+1] && Close[i+1]>Buffer4[i+1] && Close[i+1]>Buffer5[i+1] && Close[i+1]>Buffer6[i+1] && Close[i+1]>Buffer7[i+1]))
            return SIGNAL_BUY;
      if((Close[i]<Buffer0[i] && Close[i]<Buffer1[i] && Close[i]<Buffer2[i] && Close[i]<Buffer3[i] && Close[i]<Buffer4[i] && Close[i]<Buffer5[i] && Close[i]<Buffer6[i] && Close[i]<Buffer7[i]) &&
         !(Close[i+1]<Buffer0[i+1] && Close[i+1]<Buffer1[i+1] && Close[i+1]<Buffer2[i+1] && Close[i+1]<Buffer3[i+1] && Close[i+1]<Buffer4[i+1] && Close[i+1]<Buffer5[i+1] && Close[i+1]<Buffer6[i+1] && Close[i+1]<Buffer7[i+1]))
            return SIGNAL_SELL;   
   }
   return SIGNAL_NEUTRAL;
}


datetime LastNotification=TimeCurrent()-WaitTimeNotify*60;

void NotifyHit(){
   if(!EnableNotify || TimeCurrent()<(LastNotification+WaitTimeNotify*60)) return;
   if(!SendAlert && !SendApp && !SendEmail) return;
   if(Time[0]==LastNotificationTime) return;
   ENUM_TRADE_SIGNAL Signal=IsSignal(0);
   if(Signal==SIGNAL_NEUTRAL) return;
   string EmailSubject=IndicatorName+" "+Symbol()+" Notification ";
   string EmailBody="\r\n"+AccountCompany()+" - "+AccountName()+" - "+IntegerToString(AccountNumber())+"\r\n\r\n"+IndicatorName+" Notification for "+Symbol()+"\r\n\r\n";
   string AlertText=IndicatorName+" - "+Symbol()+" Notification\r\n";
   string AppText=AccountCompany()+" - "+AccountName()+" - "+IntegerToString(AccountNumber())+" - "+IndicatorName+" - "+Symbol()+" - ";
   string Text="";
   
   if(Signal!=SIGNAL_NEUTRAL){      
      Text+="The Ribbon Indicator Triggered a Signal";
   }
   
   EmailBody+=Text+"\r\n\r\n";
   AlertText+=Text+"\r\n";
   AppText+=Text+"";
   if(SendAlert) Alert(AlertText);
   if(SendEmail){
      if(!SendMail(EmailSubject,EmailBody)) Print("Error sending email "+IntegerToString(GetLastError()));
   }
   if(SendApp){
      if(!SendNotification(AppText)) Print("Error sending notification "+IntegerToString(GetLastError()));
   }
   LastNotification=TimeCurrent();
   Print(IndicatorName+"-"+Symbol()+" last notification sent "+TimeToString(LastNotification));
}


void DrawArrows(){
   RemoveArrows();
   if(!EnableDrawArrows || BarsToScan==0) return;
   int MaxBars=Bars(Symbol(),PERIOD_CURRENT);
   if(MaxBars>BarsToScan) MaxBars=BarsToScan;
   for(int i=MaxBars-2;i>=1;i--){
      DrawArrow(i);
   }
}


void RemoveArrows(){
   int Window=-1;
   for(int i=ObjectsTotal(ChartID(),Window,-1)-1;i>=0;i--){
      if(StringFind(ObjectName(i),IndicatorName+"-ARWS-",0)>=0){
         ObjectDelete(ObjectName(i));
      }
   }
}

int SignalWidth=0;

void DrawArrow(int i){
   RemoveArrowCurr();
   if(!EnableDrawArrows){
      RemoveArrows();
      return;
   }
   ENUM_TRADE_SIGNAL Signal=IsSignal(i);
   if(Signal==SIGNAL_NEUTRAL) return;
   datetime ArrowDate=iTime(Symbol(),0,i);
   string ArrowName=IndicatorName+"-ARWS-"+IntegerToString(ArrowDate);
   double ArrowPrice=0;
   int ArrowType=0;
   color ArrowColor=0;
   int ArrowAnchor=0;
   string ArrowDesc="";
   if(Signal==SIGNAL_BUY){
      ArrowPrice=Low[i];
      ArrowType=ArrowBuy; 
      ArrowColor=clrGreen;  
      ArrowAnchor=ANCHOR_TOP;
      ArrowDesc="BUY";
   }
   if(Signal==SIGNAL_SELL){
      ArrowPrice=High[i];
      ArrowType=ArrowSell;
      ArrowColor=clrRed;
      ArrowAnchor=ANCHOR_BOTTOM;
      ArrowDesc="SELL";
   }
   ObjectCreate(0,ArrowName,OBJ_ARROW,0,ArrowDate,ArrowPrice);
   ObjectSetInteger(0,ArrowName,OBJPROP_COLOR,ArrowColor);
   ObjectSetInteger(0,ArrowName,OBJPROP_SELECTABLE,false);
   ObjectSetInteger(0,ArrowName,OBJPROP_HIDDEN,true);
   ObjectSetInteger(0,ArrowName,OBJPROP_ANCHOR,ArrowAnchor);
   ObjectSetInteger(0,ArrowName,OBJPROP_ARROWCODE,ArrowType);
   SignalWidth=ArrowSize;
   ObjectSetInteger(0,ArrowName,OBJPROP_WIDTH,SignalWidth);
   ObjectSetInteger(0,ArrowName,OBJPROP_STYLE,STYLE_SOLID);
   ObjectSetInteger(0,ArrowName,OBJPROP_BGCOLOR,ArrowColor);
   ObjectSetString(0,ArrowName,OBJPROP_TEXT,ArrowDesc);
   datetime CurrTime=iTime(Symbol(),0,0);
}


void RemoveArrowCurr(){
   datetime ArrowDate=iTime(Symbol(),0,Shift);
   string ArrowName=IndicatorName+"-ARWS-"+IntegerToString(ArrowDate);
   ObjectDelete(0,ArrowName);
}

